/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.resource;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockStatePredicateParser {
    private static final Type MAP_TYPE = new TypeToken<EnumMap<class_2350, Predicate<class_2680>>>(){}.getType();
    private static final Type PREDICATE_TYPE = new TypeToken<Predicate<class_2680>>(){}.getType();
    public static final BlockStatePredicateParser INSTANCE = new BlockStatePredicateParser();
    private final PredicateDeserializer predicateDeserializer = new PredicateDeserializer();
    private final Gson GSON = new GsonBuilder().registerTypeAdapter(PREDICATE_TYPE, (Object)this.predicateDeserializer).registerTypeAdapter(ComparisonType.class, (Object)new ComparisonType.Deserializer()).registerTypeAdapter(MAP_TYPE, type -> new EnumMap(class_2350.class)).registerTypeAdapter(PredicateMap.class, (Object)new MapDeserializer()).create();

    @Nullable
    public BiPredicate<class_2350, class_2680> parse(JsonElement json) {
        return (BiPredicate)this.GSON.fromJson(json, PredicateMap.class);
    }

    private static class PredicateDeserializer
    implements JsonDeserializer<Predicate<class_2680>> {
        static final Predicate<class_2680> EMPTY = p -> false;
        ThreadLocal<Predicate<class_2680>> defaultPredicate = new ThreadLocal();

        private PredicateDeserializer() {
        }

        public Predicate<class_2680> deserialize(JsonElement jsonElement, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (jsonElement.isJsonObject()) {
                JsonObject jsonObject = jsonElement.getAsJsonObject();
                class_2248 block = (class_2248)class_2378.field_11146.method_10223(new class_2960(class_3518.method_15265((JsonObject)jsonObject, (String)"block")));
                if (block == class_2246.field_10124) {
                    return EMPTY;
                }
                Composition composition = null;
                if (jsonObject.has("defer")) {
                    if (this.defaultPredicate.get() == null) {
                        throw new JsonParseException("Cannot defer when no default is set!");
                    }
                    try {
                        composition = Composition.valueOf(class_3518.method_15265((JsonObject)jsonObject, (String)"defer").toUpperCase(Locale.ROOT));
                    }
                    catch (IllegalArgumentException e) {
                        throw new JsonSyntaxException(class_3518.method_15265((JsonObject)jsonObject, (String)"defer") + " is not a valid defer type.");
                    }
                }
                if (!jsonObject.has("predicate")) {
                    return this.compose(composition, new BlockPredicate(block));
                }
                JsonElement propsElement = jsonObject.get("predicate");
                if (propsElement.isJsonObject()) {
                    return this.compose(composition, this.parsePredicate(block, propsElement.getAsJsonObject(), context));
                }
                if (propsElement.isJsonArray()) {
                    ArrayList<Predicate<class_2680>> predicates = new ArrayList<Predicate<class_2680>>();
                    for (JsonElement ele : propsElement.getAsJsonArray()) {
                        if (ele.isJsonObject()) {
                            predicates.add(this.parsePredicate(block, ele.getAsJsonObject(), context));
                            continue;
                        }
                        throw new JsonSyntaxException("Predicate entry must be a JSON Object. Found: " + ele);
                    }
                    return this.compose(composition, new PredicateComposition(Composition.AND, predicates));
                }
            } else if (jsonElement.isJsonArray()) {
                ArrayList<Predicate<class_2680>> predicates = new ArrayList<Predicate<class_2680>>();
                for (JsonElement ele : jsonElement.getAsJsonArray()) {
                    Predicate p = (Predicate)context.deserialize(ele, PREDICATE_TYPE);
                    if (p == EMPTY) continue;
                    predicates.add(p);
                }
                return predicates.size() == 0 ? EMPTY : (predicates.size() == 1 ? (Predicate)predicates.get(0) : new PredicateComposition(Composition.OR, predicates));
            }
            throw new JsonSyntaxException("Predicate deserialization expects an object or an array. Found: " + jsonElement);
        }

        private Predicate<class_2680> compose(@Nullable Composition composition, @NotNull Predicate<class_2680> child) {
            if (composition == null) {
                return child;
            }
            return composition.composer.apply(this.defaultPredicate.get(), child);
        }

        private Predicate<class_2680> parsePredicate(@NotNull class_2248 block, JsonObject jsonObject, JsonDeserializationContext context) {
            ComparisonType compareFunc = (ComparisonType)((Object)class_3518.method_15283((JsonObject)jsonObject, (String)"compare_func", (Object)((Object)ComparisonType.EQUAL), (JsonDeserializationContext)context, ComparisonType.class));
            jsonObject.remove("compare_func");
            Set entryset = jsonObject.entrySet();
            if (entryset.size() > 1 || entryset.size() == 0) {
                throw new JsonSyntaxException("Predicate entry must define exactly one property->value pair. Found: " + entryset.size());
            }
            String key = (String)((Map.Entry)entryset.iterator().next()).getKey();
            Optional<class_2769> property = block.method_9595().method_11659().stream().filter(p -> p.method_11899().equals(key)).findFirst();
            if (!property.isPresent()) {
                throw new JsonParseException(key + " is not a valid property for blockstate " + block.method_9564());
            }
            JsonElement valueElement = jsonObject.get(key);
            if (valueElement.isJsonArray()) {
                return new MultiPropertyPredicate(block, property.get(), StreamSupport.stream(valueElement.getAsJsonArray().spliterator(), false).map(e -> this.parseValue((class_2769)property.get(), (JsonElement)e)).collect(Collectors.toSet()));
            }
            return new PropertyPredicate<Comparable>(block, property.get(), this.parseValue(property.get(), valueElement), compareFunc);
        }

        private Comparable parseValue(class_2769 property, JsonElement jsonElement) {
            String valueString = class_3518.method_15287((JsonElement)jsonElement, (String)property.method_11899());
            Optional<Object> value = property.method_11898().stream().filter(v -> property.method_11901((Comparable)v).equalsIgnoreCase(valueString)).findFirst();
            if (!value.isPresent()) {
                throw new JsonParseException(valueString + " is not a valid value for property " + property);
            }
            return (Comparable)value.get();
        }
    }

    private static enum ComparisonType {
        EQUAL("=", i -> i == 0),
        NOT_EQUAL("!=", i -> i != 0),
        GREATER_THAN(">", i -> i > 0),
        LESS_THAN("<", i -> i < 0),
        GREATER_THAN_EQ(">=", i -> i >= 0),
        LESS_THAN_EQ("<=", i -> i <= 0);

        private final String key;
        private final IntPredicate compareFunc;

        private ComparisonType(String key, IntPredicate compareFunc) {
            this.key = key;
            this.compareFunc = compareFunc;
        }

        private static class Deserializer
        implements JsonDeserializer<ComparisonType> {
            private Deserializer() {
            }

            public ComparisonType deserialize(JsonElement jsonElement, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                if (jsonElement.isJsonPrimitive() && jsonElement.getAsJsonPrimitive().isString()) {
                    Optional<ComparisonType> type = Arrays.stream(ComparisonType.values()).filter(t -> t.key.equals(jsonElement.getAsString())).findFirst();
                    if (type.isPresent()) {
                        return type.get();
                    }
                    throw new JsonParseException(jsonElement + " is not a valid comparison type!");
                }
                throw new JsonSyntaxException("ComparisonType must be a String");
            }
        }
    }

    private static class PredicateMap
    implements BiPredicate<class_2350, class_2680> {
        private final EnumMap<class_2350, Predicate<class_2680>> predicates = new EnumMap(class_2350.class);

        private PredicateMap() {
        }

        @Override
        public boolean test(class_2350 dir, class_2680 state) {
            return this.predicates.get(dir).test(state);
        }
    }

    private class MapDeserializer
    implements JsonDeserializer<PredicateMap> {
        private MapDeserializer() {
        }

        public PredicateMap deserialize(JsonElement jsonElement, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (jsonElement.isJsonObject()) {
                JsonObject jsonObject = jsonElement.getAsJsonObject();
                if (jsonObject.has("default")) {
                    BlockStatePredicateParser.this.predicateDeserializer.defaultPredicate.set((Predicate)context.deserialize(jsonObject.get("default"), PREDICATE_TYPE));
                    jsonObject.remove("default");
                }
                PredicateMap map = new PredicateMap();
                map.predicates.putAll((Map)context.deserialize((JsonElement)jsonObject, MAP_TYPE));
                for (class_2350 direction : class_2350.values()) {
                    map.predicates.putIfAbsent(direction, Optional.ofNullable(BlockStatePredicateParser.this.predicateDeserializer.defaultPredicate.get()).orElse(PredicateDeserializer.EMPTY));
                }
                BlockStatePredicateParser.this.predicateDeserializer.defaultPredicate.set(null);
                return map;
            }
            if (jsonElement.isJsonArray()) {
                Predicate predicate = (Predicate)context.deserialize(jsonElement, PREDICATE_TYPE);
                PredicateMap map = new PredicateMap();
                for (class_2350 direction : class_2350.values()) {
                    map.predicates.put(direction, predicate);
                }
                return map;
            }
            throw new JsonSyntaxException("connectTo must be an object or an array. Found: " + jsonElement);
        }
    }

    private static class PredicateComposition
    implements Predicate<class_2680> {
        private final Composition type;
        private final List<Predicate<class_2680>> composed;

        PredicateComposition(Composition type, List<Predicate<class_2680>> composed) {
            this.type = type;
            this.composed = composed;
        }

        @Override
        public boolean test(class_2680 state) {
            if (this.type == Composition.AND) {
                for (Predicate<class_2680> predicate : this.composed) {
                    if (predicate.test(state)) continue;
                    return false;
                }
                return true;
            }
            for (Predicate<class_2680> predicate : this.composed) {
                if (!predicate.test(state)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return "BlockStatePredicateParser.PredicateComposition(type=" + this.type + ", composed=" + this.composed + ")";
        }
    }

    private static final class BlockPredicate
    implements Predicate<class_2680> {
        private final class_2248 block;

        BlockPredicate(class_2248 block) {
            this.block = block;
        }

        @Override
        public boolean test(class_2680 state) {
            return state.method_26204() == this.block;
        }

        public class_2248 getBlock() {
            return this.block;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BlockPredicate)) {
                return false;
            }
            BlockPredicate other = (BlockPredicate)o;
            class_2248 this$block = this.getBlock();
            class_2248 other$block = other.getBlock();
            return !(this$block == null ? other$block != null : !this$block.equals(other$block));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            class_2248 $block = this.getBlock();
            result = result * 59 + ($block == null ? 43 : $block.hashCode());
            return result;
        }

        public String toString() {
            return "BlockStatePredicateParser.BlockPredicate(block=" + this.getBlock() + ")";
        }
    }

    private static final class MultiPropertyPredicate<T extends Comparable<T>>
    implements Predicate<class_2680> {
        private final class_2248 block;
        private final class_2769<T> property;
        private final Set<T> validValues;

        MultiPropertyPredicate(class_2248 block, class_2769<T> property, Set<T> validValues) {
            this.block = block;
            this.property = property;
            this.validValues = validValues;
        }

        @Override
        public boolean test(class_2680 state) {
            return state.method_26204() == this.block && this.validValues.contains(state.method_11654(this.property));
        }

        public class_2248 getBlock() {
            return this.block;
        }

        public class_2769<T> getProperty() {
            return this.property;
        }

        public Set<T> getValidValues() {
            return this.validValues;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MultiPropertyPredicate)) {
                return false;
            }
            MultiPropertyPredicate other = (MultiPropertyPredicate)o;
            class_2248 this$block = this.getBlock();
            class_2248 other$block = other.getBlock();
            if (this$block == null ? other$block != null : !this$block.equals(other$block)) {
                return false;
            }
            class_2769<T> this$prop = this.getProperty();
            class_2769<T> other$prop = other.getProperty();
            if (this$prop == null ? other$prop != null : !this$prop.equals(other$prop)) {
                return false;
            }
            Set<T> this$validValues = this.getValidValues();
            Set<T> other$validValues = other.getValidValues();
            return !(this$validValues == null ? other$validValues != null : !((Object)this$validValues).equals(other$validValues));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            class_2248 $block = this.getBlock();
            result = result * 59 + ($block == null ? 43 : $block.hashCode());
            class_2769<T> $prop = this.getProperty();
            result = result * 59 + ($prop == null ? 43 : $prop.hashCode());
            Set<T> $validValues = this.getValidValues();
            result = result * 59 + ($validValues == null ? 43 : ((Object)$validValues).hashCode());
            return result;
        }

        public String toString() {
            return "BlockStatePredicateParser.MultiPropertyPredicate(block=" + this.getBlock() + ", property=" + this.getProperty() + ", validValues=" + this.getValidValues() + ")";
        }
    }

    private static final class PropertyPredicate<T extends Comparable<T>>
    implements Predicate<class_2680> {
        private final class_2248 block;
        private final class_2769<T> property;
        private final T value;
        private final ComparisonType type;

        PropertyPredicate(class_2248 block, class_2769<T> property, T value, ComparisonType type) {
            this.block = block;
            this.property = property;
            this.value = value;
            this.type = type;
        }

        @Override
        public boolean test(class_2680 state) {
            return state.method_26204() == this.block && this.type.compareFunc.test(state.method_11654(this.property).compareTo(this.value));
        }

        public class_2248 getBlock() {
            return this.block;
        }

        public class_2769<T> getProperty() {
            return this.property;
        }

        public T getValue() {
            return this.value;
        }

        public ComparisonType getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PropertyPredicate)) {
                return false;
            }
            PropertyPredicate other = (PropertyPredicate)o;
            class_2248 this$block = this.getBlock();
            class_2248 other$block = other.getBlock();
            if (this$block == null ? other$block != null : !this$block.equals(other$block)) {
                return false;
            }
            class_2769<T> this$prop = this.getProperty();
            class_2769<T> other$prop = other.getProperty();
            if (this$prop == null ? other$prop != null : !this$prop.equals(other$prop)) {
                return false;
            }
            T this$value = this.getValue();
            T other$value = other.getValue();
            if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
                return false;
            }
            ComparisonType this$type = this.getType();
            ComparisonType other$type = other.getType();
            return !(this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            class_2248 $block = this.getBlock();
            result = result * 59 + ($block == null ? 43 : $block.hashCode());
            class_2769<T> $prop = this.getProperty();
            result = result * 59 + ($prop == null ? 43 : $prop.hashCode());
            T $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            ComparisonType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            return result;
        }

        public String toString() {
            return "BlockStatePredicateParser.PropertyPredicate(block=" + this.getBlock() + ", property=" + this.getProperty() + ", value=" + this.getValue() + ", type=" + this.getType() + ")";
        }
    }

    private static enum Composition {
        AND(Predicate::and),
        OR(Predicate::or);

        private final BiFunction<Predicate<class_2680>, Predicate<class_2680>, Predicate<class_2680>> composer;

        private Composition(BiFunction<Predicate<class_2680>, Predicate<class_2680>, Predicate<class_2680>> composer) {
            this.composer = composer;
        }
    }
}

